/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.xml;

import com.ibm.hwmca.fw.util.MalformedXMLException;
import com.ibm.hwmca.fw.util.Trace;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLObjectData {
    private static final String TRACE_MASKT = "XUTLXODT";
    private static final String TRACE_MASKF = "XUTLXODF";
    private static final String TRACE_MASKD = "XUTLXODD";
    protected static final String ATTRIB_NAME = "name";
    private String name = null;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getClass().getName() + " [" + "name=" + this.getName() + "]";
    }

    public void parseXML(Node node) throws MalformedXMLException {
        int i;
        Trace.trace(TRACE_MASKD, "parseXML: node=" + node.getNodeName());
        if (node.hasAttributes()) {
            NamedNodeMap attrMap = node.getAttributes();
            i = 0;
            while (i < attrMap.getLength()) {
                Node attr = attrMap.item(i);
                Trace.trace(TRACE_MASKD, "child attr=" + attr.getNodeName());
                this.parseAttribute(attr);
                ++i;
            }
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    Trace.trace(TRACE_MASKD, "child node=" + child.getNodeName());
                    this.parseSubElement(child);
                }
                ++i;
            }
        }
    }

    protected void parseAttribute(Node node) throws MalformedXMLException {
        String name = node.getNodeName().toLowerCase();
        if (!name.equals(ATTRIB_NAME)) {
            throw new MalformedXMLException("parseAttribute: Unhandled attribute '" + name + "'");
        }
        Trace.trace(TRACE_MASKD, "attr name=" + node.getNodeValue());
        this.setName(node.getNodeValue());
    }

    protected void parseSubElement(Node node) throws MalformedXMLException {
        throw new MalformedXMLException("parseSubElement: Unhandled element <" + node.getNodeName().toLowerCase() + ">");
    }
}

